#!/bin/sh

################ EasyQuanto(TM) - Start GAMESS calculations - ###########################

#JOB=$1
#JOBDIR=$2
#SCRATCH=$3
#GAMESS_PROGDIR=$4
#GAMESS_EXEC_FILE=$5

JOB=$1
JOB_DIR=$2
SCRATCH_DIR=$3
PROG_DIR=$4
EXEC_FILE=$5

started_date=`date 2>/dev/null`
started_date=`date -d "$started_date" '+%d.%m.%Y / %H:%M'`
echo "STARTED = $started_date" >> $JOB_DIR/$JOB.log


# -------- Following environments are related to Gamess only -------------------------- #

env >& $JOB_DIR/GAMESS.ENVIRON

export MKL_SERIAL=YES
export MKL_NUM_THREADS=1


# NBO calculations
#export NBOEXE=/home2/chem1/pc/mvs10p.jscc.ru/gamess/nbo6/bin/nbo6.i8.exe

#  file assignments.
export AUXDATA=$PROG_DIR/auxdata
export MCPPATH=$PROG_DIR/mcpdata
export NUCBAS=/dev/null
#
export ERICFMT=$AUXDATA/ericfmt.dat
export MCPPATH=$AUXDATA/MCP
export BASPATH=$AUXDATA/BASES
export QUANPOL=$AUXDATA/QUANPOL
export  MAKEFP=$JOB_DIR/$JOB.efp
export   GAMMA=$JOB_DIR/$JOB.gamma
export TRAJECT=$JOB_DIR/$JOB.trj
export RESTART=$JOB_DIR/$JOB.rst
export   INPUT=$JOB_DIR/$JOB.inp
export   PUNCH=$JOB_DIR/$JOB.dat
export  AOINTS=$SCRATCH_DIR/$JOB.F08
export  MOINTS=$SCRATCH_DIR/$JOB.F09
export DICTNRY=$SCRATCH_DIR/$JOB.F10
export DRTFILE=$SCRATCH_DIR/$JOB.F11
export CIVECTR=$SCRATCH_DIR/$JOB.F12
export CASINTS=$SCRATCH_DIR/$JOB.F13
export  CIINTS=$SCRATCH_DIR/$JOB.F14
export  WORK15=$SCRATCH_DIR/$JOB.F15
export  WORK16=$SCRATCH_DIR/$JOB.F16
export CSFSAVE=$SCRATCH_DIR/$JOB.F17
export FOCKDER=$SCRATCH_DIR/$JOB.F18
export  WORK19=$SCRATCH_DIR/$JOB.F19
export  DASORT=$SCRATCH_DIR/$JOB.F20
export DFTINTS=$SCRATCH_DIR/$JOB.F21
export DFTGRID=$SCRATCH_DIR/$JOB.F22
export  JKFILE=$SCRATCH_DIR/$JOB.F23
export  ORDINT=$SCRATCH_DIR/$JOB.F24
export  EFPIND=$SCRATCH_DIR/$JOB.F25
export PCMDATA=$SCRATCH_DIR/$JOB.F26
export PCMINTS=$SCRATCH_DIR/$JOB.F27
export SVPWRK1=$SCRATCH_DIR/$JOB.F26
export SVPWRK2=$SCRATCH_DIR/$JOB.F27
export  COSCAV=$SCRATCH_DIR/$JOB.F26
export COSDATA=$JOB_DIR/$JOB.cosmo
export  COSPOT=$SCRATCH_DIR/$JOB.pot
export   MLTPL=$SCRATCH_DIR/$JOB.F28
export  MLTPLT=$SCRATCH_DIR/$JOB.F29
export  DAFL30=$SCRATCH_DIR/$JOB.F30
export  SOINTX=$SCRATCH_DIR/$JOB.F31
export  SOINTY=$SCRATCH_DIR/$JOB.F32
export  SOINTZ=$SCRATCH_DIR/$JOB.F33
export  SORESC=$SCRATCH_DIR/$JOB.F34
#   35 is used by RESTART, see above
export GCILIST=$SCRATCH_DIR/$JOB.F37
export HESSIAN=$SCRATCH_DIR/$JOB.F38
export QMMMTEI=$SCRATCH_DIR/$JOB.F39
export SOCCDAT=$SCRATCH_DIR/$JOB.F40
export  AABB41=$SCRATCH_DIR/$JOB.F41
export  BBAA42=$SCRATCH_DIR/$JOB.F42
export  BBBB43=$SCRATCH_DIR/$JOB.F43
export  MCQD50=$SCRATCH_DIR/$JOB.F50
export  MCQD51=$SCRATCH_DIR/$JOB.F51
export  MCQD52=$SCRATCH_DIR/$JOB.F52
export  MCQD53=$SCRATCH_DIR/$JOB.F53
export  MCQD54=$SCRATCH_DIR/$JOB.F54
export  MCQD55=$SCRATCH_DIR/$JOB.F55
export  MCQD56=$SCRATCH_DIR/$JOB.F56
export  MCQD57=$SCRATCH_DIR/$JOB.F57
export  MCQD58=$SCRATCH_DIR/$JOB.F58
export  MCQD59=$SCRATCH_DIR/$JOB.F59
export  MCQD60=$SCRATCH_DIR/$JOB.F60
export  MCQD61=$SCRATCH_DIR/$JOB.F61
export  MCQD62=$SCRATCH_DIR/$JOB.F62
export  MCQD63=$SCRATCH_DIR/$JOB.F63
export  MCQD64=$SCRATCH_DIR/$JOB.F64
export NMRINT1=$SCRATCH_DIR/$JOB.F61
export NMRINT2=$SCRATCH_DIR/$JOB.F62
export NMRINT3=$SCRATCH_DIR/$JOB.F63
export NMRINT4=$SCRATCH_DIR/$JOB.F64
export NMRINT5=$SCRATCH_DIR/$JOB.F65
export NMRINT6=$SCRATCH_DIR/$JOB.F66
export DCPHFH2=$SCRATCH_DIR/$JOB.F67
export DCPHF21=$SCRATCH_DIR/$JOB.F68
export ELNUINT=$SCRATCH_DIR/$JOB.F67
export NUNUINT=$SCRATCH_DIR/$JOB.F68
export   GVVPT=$SCRATCH_DIR/$JOB.F69
export  NUMOIN=$SCRATCH_DIR/$JOB.F69
export NUMOCAS=$SCRATCH_DIR/$JOB.F70
export  NUELMO=$SCRATCH_DIR/$JOB.F71
export NUELCAS=$SCRATCH_DIR/$JOB.F72

#    next files are for RI-MP2
export RIVMAT=$SCRATCH_DIR/$JOB.F51
export  RIT2A=$SCRATCH_DIR/$JOB.F52
export  RIT3A=$SCRATCH_DIR/$JOB.F53
export  RIT2B=$SCRATCH_DIR/$JOB.F54
export  RIT3B=$SCRATCH_DIR/$JOB.F55

#    Next files are for GMCQDPT
export GMCREF=$SCRATCH_DIR/$JOB.F70
export GMCO2R=$SCRATCH_DIR/$JOB.F71
export GMCROC=$SCRATCH_DIR/$JOB.F72
export GMCOOC=$SCRATCH_DIR/$JOB.F73
export GMCCC0=$SCRATCH_DIR/$JOB.F74
export GMCHMA=$SCRATCH_DIR/$JOB.F75
export GMCEI1=$SCRATCH_DIR/$JOB.F76
export GMCEI2=$SCRATCH_DIR/$JOB.F77
export GMCEOB=$SCRATCH_DIR/$JOB.F78
export GMCEDT=$SCRATCH_DIR/$JOB.F79
export GMCERF=$SCRATCH_DIR/$JOB.F80
export GMCHCR=$SCRATCH_DIR/$JOB.F81
export GMCGJK=$SCRATCH_DIR/$JOB.F82
export GMCGAI=$SCRATCH_DIR/$JOB.F83
export GMCGEO=$SCRATCH_DIR/$JOB.F84
export GMCTE1=$SCRATCH_DIR/$JOB.F85
export GMCTE2=$SCRATCH_DIR/$JOB.F86
export GMCHEF=$SCRATCH_DIR/$JOB.F87
export GMCMOL=$SCRATCH_DIR/$JOB.F88
export GMCMOS=$SCRATCH_DIR/$JOB.F89
export GMCWGT=$SCRATCH_DIR/$JOB.F90
export GMCRM2=$SCRATCH_DIR/$JOB.F91
export GMCRM1=$SCRATCH_DIR/$JOB.F92
export GMCR00=$SCRATCH_DIR/$JOB.F93
export GMCRP1=$SCRATCH_DIR/$JOB.F94
export GMCRP2=$SCRATCH_DIR/$JOB.F95
export GMCVEF=$SCRATCH_DIR/$JOB.F96
export GMCDIN=$SCRATCH_DIR/$JOB.F97
export GMC2SZ=$SCRATCH_DIR/$JOB.F98
export GMCCCS=$SCRATCH_DIR/$JOB.F99

#    Next files are used only during closed shell coupled cluster runs.
#    Display the numerous definitions iff they are going to be used.
#unset echo
#set cctyp=`grep -i 'CCTYP[(=]' $SCRATCH_DIR/$JOB.F05 | wc -l`
#if ($cctyp > 0) set echo
export  CCREST=$SCRATCH_DIR/$JOB.F70
export  CCDIIS=$SCRATCH_DIR/$JOB.F71
export  CCINTS=$SCRATCH_DIR/$JOB.F72
export CCT1AMP=$SCRATCH_DIR/$JOB.F73
export CCT2AMP=$SCRATCH_DIR/$JOB.F74
export CCT3AMP=$SCRATCH_DIR/$JOB.F75
export    CCVM=$SCRATCH_DIR/$JOB.F76
export    CCVE=$SCRATCH_DIR/$JOB.F77
export CCQUADS=$SCRATCH_DIR/$JOB.F78
export QUADSVO=$SCRATCH_DIR/$JOB.F79
export EOMSTAR=$SCRATCH_DIR/$JOB.F80
export EOMVEC1=$SCRATCH_DIR/$JOB.F81
export EOMVEC2=$SCRATCH_DIR/$JOB.F82
export  EOMHC1=$SCRATCH_DIR/$JOB.F83
export  EOMHC2=$SCRATCH_DIR/$JOB.F84
export EOMHHHH=$SCRATCH_DIR/$JOB.F85
export EOMPPPP=$SCRATCH_DIR/$JOB.F86
export EOMRAMP=$SCRATCH_DIR/$JOB.F87
export EOMRTMP=$SCRATCH_DIR/$JOB.F88
export EOMDG12=$SCRATCH_DIR/$JOB.F89
export    MMPP=$SCRATCH_DIR/$JOB.F90
export   MMHPP=$SCRATCH_DIR/$JOB.F91
export MMCIVEC=$SCRATCH_DIR/$JOB.F92
export MMCIVC1=$SCRATCH_DIR/$JOB.F93
export MMCIITR=$SCRATCH_DIR/$JOB.F94
export  EOMVL1=$SCRATCH_DIR/$JOB.F95
export  EOMVL2=$SCRATCH_DIR/$JOB.F96
export EOMLVEC=$SCRATCH_DIR/$JOB.F97
export  EOMHL1=$SCRATCH_DIR/$JOB.F98
export  EOMHL2=$SCRATCH_DIR/$JOB.F99
export  CCVVVV=$SCRATCH_DIR/$JOB.F80
#
#    Next files are used only during open shell coupled cluster runs.
#
export AMPROCC=$SCRATCH_DIR/$JOB.F70
export ITOPNCC=$SCRATCH_DIR/$JOB.F71
export FOCKMTX=$SCRATCH_DIR/$JOB.F72
export  LAMB23=$SCRATCH_DIR/$JOB.F73
export   VHHAA=$SCRATCH_DIR/$JOB.F74
export   VHHBB=$SCRATCH_DIR/$JOB.F75
export   VHHAB=$SCRATCH_DIR/$JOB.F76
export    VMAA=$SCRATCH_DIR/$JOB.F77
export    VMBB=$SCRATCH_DIR/$JOB.F78
export    VMAB=$SCRATCH_DIR/$JOB.F79
export    VMBA=$SCRATCH_DIR/$JOB.F80
export  VHPRAA=$SCRATCH_DIR/$JOB.F81
export  VHPRBB=$SCRATCH_DIR/$JOB.F82
export  VHPRAB=$SCRATCH_DIR/$JOB.F83
export  VHPLAA=$SCRATCH_DIR/$JOB.F84
export  VHPLBB=$SCRATCH_DIR/$JOB.F85
export  VHPLAB=$SCRATCH_DIR/$JOB.F86
export  VHPLBA=$SCRATCH_DIR/$JOB.F87
export    VEAA=$SCRATCH_DIR/$JOB.F88
export    VEBB=$SCRATCH_DIR/$JOB.F89
export    VEAB=$SCRATCH_DIR/$JOB.F90
export    VEBA=$SCRATCH_DIR/$JOB.F91
export   VPPPP=$SCRATCH_DIR/$JOB.F92
export INTERM1=$SCRATCH_DIR/$JOB.F93
export INTERM2=$SCRATCH_DIR/$JOB.F94
export INTERM3=$SCRATCH_DIR/$JOB.F95
export ITSPACE=$SCRATCH_DIR/$JOB.F96
export INSTART=$SCRATCH_DIR/$JOB.F97
export  ITSPC3=$SCRATCH_DIR/$JOB.F98

export SIMEN=$SCRATCH_DIR/$JOB.simen
export SIMCOR=$SCRATCH_DIR/$JOB.simcor
export FCIINF=$SCRATCH_DIR/$JOB.F90
export FCIINT=$SCRATCH_DIR/$JOB.F91

#    Next files are used only during elongation method runs.
#    Display the numerous definitions iff they are going to be used.
#set elgtyp = `grep -i NELONG= $SCRATCH_DIR/$JOB.F05 | wc -l`
#if ($elgtyp > 0) then
#    set ELGNAME=$4
#    if (null$4 == null) set ELGNAME=ELGFILE
#    set echo
#    export AOINTS  =$SCRATCH_DIR/$ELGNAME.F08
#    export ELGDOS  ="$SCRATCH_DIR/$JOB.ldos"
#    export ELGDAT  =$SCRATCH_DIR/$ELGNAME.F71
#    export ELGPAR  =$SCRATCH_DIR/$ELGNAME.F72
#    export ELGCUT  =$SCRATCH_DIR/$ELGNAME.F74
#    export ELGVEC  =$SCRATCH_DIR/$ELGNAME.F75
#    export EGINTA  =$SCRATCH_DIR/$ELGNAME.F77
#    export EGINTB  =$SCRATCH_DIR/$ELGNAME.F78
#    export EGTDHF  =$SCRATCH_DIR/$ELGNAME.F79
#    export EGTEST  =$SCRATCH_DIR/$ELGNAME.F80
#    unset echo
#fi
#
#    Next files are used only during extended TDHF package runs.
#    Display the numerous definitions iff they are going to be used.
#unset echo
#set txtyp=`grep -i RUNTYP=TDHFX $SCRATCH_DIR/$JOB.F05 | wc -l`
#if ($txtyp > 0) set echo
export  OLI201=$SCRATCH_DIR/$JOB.F201
export  OLI202=$SCRATCH_DIR/$JOB.F202
export  OLI203=$SCRATCH_DIR/$JOB.F203
export  OLI204=$SCRATCH_DIR/$JOB.F204
export  OLI205=$SCRATCH_DIR/$JOB.F205
export  OLI206=$SCRATCH_DIR/$JOB.F206
export  OLI207=$SCRATCH_DIR/$JOB.F207
export  OLI208=$SCRATCH_DIR/$JOB.F208
export  OLI209=$SCRATCH_DIR/$JOB.F209
export  OLI210=$SCRATCH_DIR/$JOB.F210
export  OLI211=$SCRATCH_DIR/$JOB.F211
export  OLI212=$SCRATCH_DIR/$JOB.F212
export  OLI213=$SCRATCH_DIR/$JOB.F213
export  OLI214=$SCRATCH_DIR/$JOB.F214
export  OLI215=$SCRATCH_DIR/$JOB.F215
export  OLI216=$SCRATCH_DIR/$JOB.F216
export  OLI217=$SCRATCH_DIR/$JOB.F217
export  OLI218=$SCRATCH_DIR/$JOB.F218
export  OLI219=$SCRATCH_DIR/$JOB.F219
export  OLI220=$SCRATCH_DIR/$JOB.F220
export  OLI221=$SCRATCH_DIR/$JOB.F221
export  OLI222=$SCRATCH_DIR/$JOB.F222
export  OLI223=$SCRATCH_DIR/$JOB.F223
export  OLI224=$SCRATCH_DIR/$JOB.F224
export  OLI225=$SCRATCH_DIR/$JOB.F225
export  OLI226=$SCRATCH_DIR/$JOB.F226
export  OLI227=$SCRATCH_DIR/$JOB.F227
export  OLI228=$SCRATCH_DIR/$JOB.F228
export  OLI229=$SCRATCH_DIR/$JOB.F229
export  OLI230=$SCRATCH_DIR/$JOB.F230
export  OLI231=$SCRATCH_DIR/$JOB.F231
export  OLI232=$SCRATCH_DIR/$JOB.F232
export  OLI233=$SCRATCH_DIR/$JOB.F233
export  OLI234=$SCRATCH_DIR/$JOB.F234
export  OLI235=$SCRATCH_DIR/$JOB.F235
export  OLI236=$SCRATCH_DIR/$JOB.F236
export  OLI237=$SCRATCH_DIR/$JOB.F237
export  OLI238=$SCRATCH_DIR/$JOB.F238
export  OLI239=$SCRATCH_DIR/$JOB.F239
unset echo
#    Next files are used only during divide-and-conquer runs
export   DCSUB=$SCRATCH_DIR/$JOB.F250
export   DCVEC=$SCRATCH_DIR/$JOB.F251
export   DCEIG=$SCRATCH_DIR/$JOB.F252
export   DCDM=$SCRATCH_DIR/$JOB.F253
export   DCDMO=$SCRATCH_DIR/$JOB.F254
export   DCQ=$SCRATCH_DIR/$JOB.F255
export   DCW=$SCRATCH_DIR/$JOB.F256
export   DCEDM=$SCRATCH_DIR/$JOB.F257

#    Next files are used only during LMO hyperpolarizability analysis
export LHYPWRK=$SCRATCH_DIR/$JOB.F297
export LHYPWK2=$SCRATCH_DIR/$JOB.F298
export BONDDPF=$SCRATCH_DIR/$JOB.F299

#    Next value is used only within the VB2000 add-on code
# export GMSJOBNAME="$JOB"


#    If a $GDDI input group is present, the calculation will be using
#    subgroups within DDI (the input NGROUP=0 means this isn't GDDI).
#
#    The master within each group must have a copy of INPUT, which is
#    dealt with below (prior to execution), once we know something about
#    the host names where INPUT is required.  The INPUT does not have
#    the global rank appended to its name, unlike all other files.
#
#    OUTPUT and PUNCH (and perhaps many other files) are opened on all
#    processes (not just the master in each subgroup), but unique names
#    will be generated by appending the global ranks.  Note that OUTPUT
#    is not opened by the master in the first group, but is used by all
#    other groups.  Typically, the OUTPUT from the first group's master
#    is the only one worth saving, unless perhaps if runs crash out.
#
#    The other files that GDDI runs might use are already defined above.
#
#set ngddi=`grep -i '^ \$GDDI' $SCRATCH_DIR/$JOB.F05 | grep -iv 'NGROUP=0 ' | wc -l`
#if ($ngddi > 0) then
#   set GDDIjob=true
#   echo "This is a GDDI run, keeping various output files on local disks"
#   set echo
#   export  OUTPUT="$SCRATCH_DIR/$JOB.F06"
#   export   PUNCH=" $SCRATCH_DIR/$JOB.F07"
#   unset echo
#else
#   set GDDIjob=false
#endif

#    data left over from a previous run might be precious, stop if found.
#if [ -e $SCRATCH_DIR ] || [ -e $IRCDATA ] || [ -e $TRAJECT ]; then
#   echo Please rename/erase $SCRATCH_DIR and/or $IRCDATA, and resubmit
#   exit 4
#    rm -f $SCRATCH_DIR $IRCDATA $TRAJECT
#fi

#   env >& $SCRATCH_DIR/GAMESS.ENVIRON
#      chdir $SCRATCH_DIR

# ----- Now starting Gamess calculations ---------------------------------------------- #

exec_string="$PROG_DIR/$EXEC_FILE -scr $SCRATCH_DIR"

$exec_string >> $JOB_DIR/$JOB.out
err_lvl=$?

rm -rf $SCRATCH_DIR/$JOB.F* &>/dev/null

finished_date=`date 2>/dev/null`
finished_date=`date -d "$finished_date" '+%d.%m.%Y / %H:%M'`
echo "FINISHED = $finished_date" >> $JOB_DIR/$JOB.log

exit $err_lvl

#########################################################################################
